/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Astropos;
import cds.astro.Coo;
import cds.astro.ICRS;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class TestGaia {
    public static void main(String[] stringArray) throws IOException {
        Path path = FileSystems.getDefault().getPath("data", "sample1000-gaia_source-final.csv");
        List<String> list = Files.readAllLines(path);
        list.remove(0);
        ArrayList arrayList = new ArrayList(list.size());
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (String string : list) {
            String[] stringArray2 = string.split(",");
            double d5 = Double.parseDouble(stringArray2[5]);
            double d6 = Double.parseDouble(stringArray2[7]);
            double[] dArray = new double[3];
            double[] dArray2 = new double[]{Double.parseDouble(stringArray2[6]), Double.parseDouble(stringArray2[8]), Double.parseDouble(stringArray2[17])};
            dArray2[2] = dArray2[2] * (dArray2[0] * dArray2[1]);
            dArray2[0] = dArray2[0] * dArray2[0];
            dArray2[1] = dArray2[1] * dArray2[1];
            Astropos.varianceToErrorEllipse(dArray2, dArray);
            double d7 = stringArray2[13].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[13]);
            double d8 = stringArray2[15].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[15]);
            double[] dArray3 = new double[3];
            double[] dArray4 = new double[]{stringArray2[14].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[14]), stringArray2[16].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[16]), stringArray2[26].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[26])};
            dArray4[2] = dArray4[2] * (dArray4[0] * dArray4[1]);
            dArray4[0] = dArray4[0] * dArray4[0];
            dArray4[1] = dArray4[1] * dArray4[1];
            Astropos.varianceToErrorEllipse(dArray4, dArray3);
            double[] dArray5 = new double[]{stringArray2[9].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[9]), stringArray2[10].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[10])};
            double[] dArray6 = new double[]{stringArray2[89].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[89]), stringArray2[90].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[90])};
            double[] dArray7 = new double[]{stringArray2[17].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[17]), stringArray2[18].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[18]), stringArray2[19].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[19]), stringArray2[20].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[20]), stringArray2[21].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[21]), stringArray2[22].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[22]), stringArray2[23].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[23]), stringArray2[24].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[24]), stringArray2[25].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[25]), stringArray2[26].isEmpty() ? 0.0 : Double.parseDouble(stringArray2[26])};
            Astropos astropos = new Astropos(ICRS.create(2016.0), d5, d6, 2016.0, dArray, d7, d8, 2016.0, dArray3, dArray5, dArray6);
            if (astropos.setCorrelations(dArray7)) continue;
            System.out.println("Set correlation failed!");
            if (astropos.toEpoch(2000.0)) {
                double d9 = Double.parseDouble(stringArray2[111]);
                double d10 = Double.parseDouble(stringArray2[112]);
                double d11 = Double.parseDouble(stringArray2[113]);
                double d12 = Double.parseDouble(stringArray2[114]);
                double d13 = Double.parseDouble(stringArray2[115]);
                double d14 = astropos.getLon();
                double d15 = astropos.getLat();
                double[] dArray8 = new double[3];
                double[] dArray9 = new double[3];
                astropos.copyErrorEllipse(dArray8);
                Astropos.errorEllipseToVariance(dArray8, dArray9);
                double d16 = Coo.distance(d9, d10, d14, d15) / 3600000.0;
                double d17 = Math.abs(d11 - Math.sqrt(dArray9[0]));
                double d18 = Math.abs(d12 - Math.sqrt(dArray9[1]));
                double d19 = Math.abs(d13 - dArray9[2] / Math.sqrt(dArray9[0] * dArray9[1]));
                if (d < d16) {
                    d = d16;
                }
                if (d2 < d17) {
                    d2 = d17;
                }
                if (d3 < d18) {
                    d3 = d18;
                }
                if (d4 < d19) {
                    d4 = d19;
                }
                System.out.println("i: " + n + "; d: " + d16 + " mas,  diff1: " + d17 + " diff2: " + d18 + " diff3: " + d19);
            } else {
                System.out.println("Conversion to J2000.0 failed!");
            }
            ++n;
        }
        System.out.println("d: " + d + "; d1: " + d2 + "; d2: " + d3 + "; d3: " + d4);
    }
}

